#ifndef _EEEfunctions_H
#define _EEEfunctions_H

#define __SEG_START_REF(a)	__SEG_START ## a
#define __SEG_END_REF(a)	__SEG_END ## a
#define __SEG_SIZE_REF(a)	__SEG_SIZE ## a

#define __SEG_START_DEF(a) extern char __SEG_START_REF(a) []
#define __SEG_END_DEF(a)   extern char __SEG_END_REF(a) []
#define __SEG_SIZE_DEF(a)  extern char __SEG_SIZE_REF(a) []

extern char __SEG_START_RAM_FUNCS[];
extern char __SEG_SIZE_RAM_FUNCS[];

#define FLASH_COPY_START 	0xE200
#define RAM_FUNCS_START	  0x0060
#define RAM_FUNCS_SIZE		85

#define DUMMY_BYTE		0xFF
#define BLANK_CHECK		0x05
#define PROGRAM			  0x20
#define BURST_PROGRAM 0x25
#define PAGE_ERASE		0x40
#define MASS_ERASE		0x41

uchar ProgramEEEBytes(uchar *, uchar *, uchar );
uchar EraseEEEPage(uchar *);
void CopyFLASHfuncsToRAM( uchar *src, uchar *dest, uchar size);

#pragma CODE_SEG FLASH_ROUTINES

uchar  ProgEraseFlash(uchar cmd, uchar *progaddress, uchar *bufferaddress, schar buffersize);

#pragma CODE_SEG DEFAULT

#define PASS 0u
#define FAIL 1u

#endif